import { DirectionMap, Directions, Tile } from "./Tile.js";
export class Player extends Tile {
    constructor(mainScene, column, row, level) {
        super(mainScene, column, row, "player", level);
        this.mainScene = mainScene;
        this.column = column;
        this.row = row;
        this.level = level;
        this.cursorState = { "up": 0, "down": 0, "left": 0, "right": 0 };
        this.cursorHistory = [];
        this.frameNumber = Tile.framesPerStep;
        this.cursors = this.scene.input.keyboard.createCursorKeys();
        this.scene.events.addListener('update', this.update, this);
    }
    update() {
        let time = performance.now();
        for (let direction of Directions) {
            if (this.cursors[direction].isDown) {
                if (time - this.cursorState[direction] > Tile.stepDurationInMs) {
                    this.cursorHistory.push(direction);
                    this.cursorState[direction] = time;
                }
            }
            else {
                if (this.cursorState[direction]) {
                    this.cursorState[direction] = 0;
                }
            }
        }
        this.frameNumber--;
        if (this.frameNumber <= 0) {
            let moved = false;
            while (this.cursorHistory.length > 0 && !moved) {
                let direction = this.cursorHistory.splice(0, 1)[0];
                let newColumn = this.column + DirectionMap[direction].dx;
                let newRow = this.row + DirectionMap[direction].dy;
                if (newColumn >= 0 && newRow >= 0 && newColumn < this.level.tiles.length) {
                    let columnList = this.level.tiles[newColumn];
                    if (newRow < columnList.length) {
                        let tileAtNewPosition = columnList[newRow];
                        if (tileAtNewPosition == null) { // Space!
                            moved = true;
                        }
                        else {
                            switch (tileAtNewPosition.kind) {
                                case "sand":
                                    columnList[newRow] = null;
                                    moved = true;
                                    this.destroyTile(tileAtNewPosition);
                                    break;
                                case "gemstone":
                                    columnList[newRow] = null;
                                    moved = true;
                                    this.destroyTile(tileAtNewPosition);
                                    this.mainScene.getScoreBoard().removeGems(1);
                                    break;
                                case "doorbottom":
                                case "doortop":
                                    moved = true;
                                    this.mainScene.nextLevel();
                                    return;
                                    break;
                            }
                        }
                        if (moved) {
                            this.goTo(newColumn, newRow);
                            this.frameNumber = Tile.framesPerStep;
                        }
                    }
                }
            }
        }
    }
    destroyTile(tile) {
        this.scene.tweens.add({
            targets: tile,
            alpha: 0,
            duration: Tile.stepDurationInMs,
            onComplete: () => {
                tile.destroy();
            }
        });
    }
    destroy() {
        this.scene.events.removeListener('update', this.update);
        super.destroy();
    }
}
//# sourceMappingURL=Player%20copy.js.map